/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.utils;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2556;
import net.minecraft.class_5321;
import net.minecraft.class_7471;
import net.minecraft.class_7604;

public final class ChatUtils {
    private static Map<String, String[]> defaultDialog = new HashMap<String, String[]>();

    public static void initDefault(Map<String, String[]> defaultDialog) {
        ChatUtils.defaultDialog = defaultDialog == null ? Map.of() : defaultDialog;
    }

    public static void reply(TrainerMob source, class_1657 target, String context) {
        String[] messages = RCTMod.getInstance().getTrainerManager().getData(source).getDialog().get(context);
        if (messages == null) {
            ModCommon.LOG.error(String.format("Invalid dialog context '%s'", context));
        } else if (messages.length > 0) {
            class_7471 message = class_7471.method_45041((String)messages[(target.method_59922().method_43054() & Integer.MAX_VALUE) % messages.length]);
            target.method_5671().method_44749(class_7604.method_44857((class_7471)message), false, class_2556.method_44832((class_5321)class_2556.field_11737, (class_1297)source));
        }
    }

    public static void reply(class_1309 source, class_1657 target, String context) {
        String[] messages = defaultDialog.get(context);
        if (messages == null) {
            ModCommon.LOG.error(String.format("Invalid dialog context '%s'", context));
        } else if (messages.length > 0) {
            class_7471 message = class_7471.method_45041((String)messages[(target.method_59922().method_43054() & Integer.MAX_VALUE) % messages.length]);
            target.method_5671().method_44749(class_7604.method_44857((class_7471)message), false, class_2556.method_44832((class_5321)class_2556.field_11737, (class_1297)source));
        }
    }

    public static void replyRaw(class_1309 source, class_1657 target, String rawMessage) {
        class_7471 message = class_7471.method_45041((String)rawMessage);
        target.method_5671().method_44749(class_7604.method_44857((class_7471)message), false, class_2556.method_44832((class_5321)class_2556.field_11737, (class_1297)source));
    }

    public static void sendTitle(class_1657 target, String title, String subtitle) {
        try {
            class_2168 cs = target.method_5671().method_9206(2).method_9217();
            if (subtitle != null && !subtitle.isBlank()) {
                cs.method_54310().execute(String.format("title @s subtitle {\"text\": \"%s\", \"italic\": true}", subtitle), (Object)cs);
            }
            if (title == null) {
                title = "";
            }
            cs.method_54310().execute(String.format("title @s title {\"text\": \"%s\"}", title), (Object)cs);
        }
        catch (CommandSyntaxException e) {
            ModCommon.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private ChatUtils() {
    }
}

